/*
 * Copyright (C) 2003 Yokogawa Electric Corporation,
 * INTAP(Interoperability Technology Association
 * for Information Processing, Japan). 
 * Copyright (C) IBM Corporation 2003.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with 
 * or without modification, are permitted provided that the following 
 * conditions and disclaimer are agreed and accepted by the user:
 * 
 * 1. Redistributions of source code must retain the above copyright 
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright 
 * notice, this list of conditions and the following disclaimer in the 
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the names of the copyrighters, the name of the project which 
 * is related to this software (hereinafter referred to as "project") nor 
 * the names of the contributors may be used to endorse or promote products 
 * derived from this software without specific prior written permission.
 * 
 * 4. No merchantable use may be permitted without prior written 
 * notification to the copyrighters. However, using this software for the 
 * purpose of testing or evaluating any products including merchantable 
 * products may be permitted without any notification to the copyrighters.
 * 
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHTERS, THE PROJECT AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING 
 * BUT NOT LIMITED THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, ARE DISCLAIMED.  IN NO EVENT SHALL THE 
 * COPYRIGHTERS, THE PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT,STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 *    Author: Kazuo Hiekata <hiekata@yamato.ibm.com>
 */

#include "McSub.h"
#include "MmHeader.h"
#include "ItPosition.h"
#include "WObject.h"
#include "RObject.h"
#include "PControl.h"
#include "PvObject.h"
#include "PvOctets.h"
#include "PAlgorithm.h"
#include "McMLDv2.h"

#include <stdio.h>
#include <string.h>

#define MLDV2_ADDRRECORD_OFFSET 20
	// 1(Record Type)+1(Aux Data Len)+2(Number of Sources)+16(Multicast Address) = 20 bytes
#define MLDV2ADDRLEN	16
	// address record length = 16 bytes
uint32_t McMLDv2_AddrRecord::length_for_reverse(RControl &, ItPosition &at, OCTBUF &buf) const {
	uint32_t valulen = auxdatalen_->value(at, buf) * 4 + (numofsrc_->value(at, buf) * MLDV2ADDRLEN);
	uint32_t length = valulen + MLDV2_ADDRRECORD_OFFSET;

	return(length);
}
bool McMLDv2_AddrRecord::HCGENE(NumOfSources)(WControl &cntr, WObject *wmem, OCTBUF &buf) const {
	WObject *wc = wmem->parent();
	CmQueue* n=0;
	uint32_t valulen = 0;
	/* counting childs */
	for(n=wc->nextChild();n!=0;n=wc->nextChild(n))
		valulen++;
	PvNumber def(valulen - 5); // subtract (Type AuxDataLen NumOfSources MulticastAddress AuxData)
	return(def.generate(cntr, wmem, buf));
}
#undef MLDV2_ADDRRECORD_OFFSET
#undef MLDV2ADDRLEN
