/*
 * Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011
 * Yokogawa Electric Corporation, YDC Corporation,
 * IPA (Information-technology Promotion Agency, Japan).
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with 
 * or without modification, are permitted provided that the following 
 * conditions and disclaimer are agreed and accepted by the user:
 * 
 * 1. Redistributions of source code must retain the above copyright 
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright 
 * notice, this list of conditions and the following disclaimer in the 
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the names of the copyrighters, the name of the project which 
 * is related to this software (hereinafter referred to as "project") nor 
 * the names of the contributors may be used to endorse or promote products 
 * derived from this software without specific prior written permission.
 * 
 * 4. No merchantable use may be permitted without prior written 
 * notification to the copyrighters. However, using this software for the 
 * purpose of testing or evaluating any products including merchantable 
 * products may be permitted without any notification to the copyrighters.
 * 
 * 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHTERS, THE PROJECT AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING 
 * BUT NOT LIMITED THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE, ARE DISCLAIMED.  IN NO EVENT SHALL THE 
 * COPYRIGHTERS, THE PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT,STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $TAHI: v6eval/lib/Cm/CmMain.h,v 1.9 2009/08/27 00:10:04 akisada Exp $
 */
#ifndef _Cm_CmMain_h_
#define _Cm_CmMain_h_	1
/* Interface Definition */
#include "CmTypes.h"
#include "BtList.h"
typedef void (*exitHandler)(int);
//======================================================================
// CmMain: ץγϤӽλ
// C/C++Υץmain()ؿǽϤexit()ؿǽλ
//----------------------------------------------------------------------
// (1) 
// CmMainϡmain()Ϥ줿Ķݻ롢ʲξ󶡤
//	ưΰ
//	ưδĶѿ
//	ưޥ̾
//	ư/ưץ̾/ư桼̾㳲Ͼ
// ʤ嵭㳲ϾcoreϻwhatǻȲǽȤʤ
// ƥ˶̤ͤȤɬפʾ󶡤
//	ץץǤեκ
//	ۥ̾
// ʤɬפ˱¾ΥƥɲòǽǤ
// ޤĶѿʤɤⶦ̤˼갷ͤˤΤ˾ޤ
//----------------------------------------------------------------------
// (2) λ
// λؿϿӼưƤӽФ
//	λɬפʾ硢ؿϿԤ
//	) ѥβ...
// ƥ㳲μưư
//----------------------------------------------------------------------
// (3) ʥ
// ץߤ뤹٤ƤΥʥª졢㳲ȯɽ
//----------------------------------------------------------------------
// (4) ˡ
// ץꥱΥᥤؿǤϡvoid applicationMain(CmMain*)
// ˽ץꥱᥤεҤԤ
// Ҥưפˤ뤿applMain()ޥѰդƤ롣
//----------------------------------------------------------------------
// (5) 
// #include "CmMain.h"
// void callMeWhenExit(int i) {
//	...}
// someFunction() {
//	...
//	exit(1);}				// exitؿλѤ¤
// applMain() {
//	atexit(callMeWhenExit);	// ʣϿǽ
//	int argc=main->argc();
//	STR *argv=main->argv();
//	...
//	}
//----------------------------------------------------------------------
// (6) 㳲Ͼ
// % what core | grep START
// 96/06/19 12:20:29 t1array STARTED by tamura@alps on
// pty/ttyvc:tamura from dog:0.0
// ư ץ̾ STARTED by ư桼@ưޥ on
// ttyname:桼̾ from ⡼ȥޥ̾
//----------------------------------------------------------------------
struct CmMain {
private:
static	STR applicationName_;		// ưޥ̾
static	char catchStart_[256];		// 㳲Ͼ
	int argCount_;			// ưο
	STR *orgArgs_;			// ư
	STR *saveArgs_;			// ưʣ
	STR *saveEnvp_;			// Ķѿ
static	CmMain* instance_;
public:
static	CmMain* instance();
	~CmMain();
	CmMain(int argc,STR *argv,STR *envp);
//----------------------------------------------------------------------
// ư
	int argc() const;
	STR*argv() const;
	STR applicationName(STR pgm=0);
	const STR command() const;
	const STR* const saveArguments() const;
	const STR catchEyeStart() const;
static	void setDbgFlags(CSTR);
//----------------------------------------------------------------------
// ƥ
	const int getdtablesize();
	const STR myHostname();
//----------------------------------------------------------------------
// λ
	void restart();
private:
//----------------------------------------------------------------------
// ؿ
	void save(int);
	void makeCatch2Eye(STR);
	void makeCatchEye(const STR);
	const STR *saveArgs() const;
	const STR *saveEnvp() const;
};
extern char dbgFlags[];
extern uint32_t logLevel;
extern bool DoHexDump;
#define applMain() void applicationMain(CmMain* main) 
//----------------------------------------------------------------------
// inlineؿ
inline	CmMain* CmMain::instance() {return instance_;}
inline	int CmMain::argc() const {return argCount_;}
inline	STR*CmMain::argv() const {return orgArgs_;}
inline	const STR CmMain::catchEyeStart() const	{return catchStart_;}
inline	const STR CmMain::command() const 	{return saveArgs_[0];}
inline	const STR*CmMain::saveArgs() const 	{return saveArgs_;}
inline	const STR*CmMain::saveEnvp() const 	{return saveEnvp_;}
inline	const STR* const CmMain::saveArguments() const 	{return saveArgs_;}

#ifndef DBGFLAGS
// avoid warning of compilation
//     gcc version 3.3.1 [FreeBSD]
//     warning: array subscript has type `char'
#define DBGFLAGS(c)	(dbgFlags[(int)(c)])
#endif	// DBGFLAGS
#endif
